export const translations = {
  fr: {
    translation: {
      // Navigation
      'nav.home': 'Accueil',
      'nav.about': 'À Propos',
      'nav.services': 'Services',
      'nav.products': 'Produits',
      'nav.workshops': 'Ateliers',
      'nav.brands': 'Marques',
      'nav.contact': 'Contact',
      'nav.login': 'Connexion',
      'nav.dashboard': 'Tableau de Bord',
      
      // Homepage Hero
      'hero.title': 'Pièces Automobiles de Qualité',
      'hero.subtitle': 'Votre partenaire de confiance pour toutes vos pièces auto',
      'hero.cta': 'Découvrir nos produits',
      'hero.cta2': 'Nous contacter',
      
      // Services
      'services.title': 'Nos Services',
      'services.subtitle': 'Des solutions complètes pour tous vos besoins',
      'services.import': 'Import de Pièces',
      'services.import.desc': 'Importation directe des meilleurs fournisseurs mondiaux',
      'services.distribution': 'Distribution',
      'services.distribution.desc': 'Réseau de distribution couvrant tout le territoire',
      'services.workshop': 'Support Atelier',
      'services.workshop.desc': 'Accompagnement technique pour les professionnels',
      'services.b2b': 'Plateforme B2B',
      'services.b2b.desc': 'Commande en ligne 24/7 avec tarifs personnalisés',
      
      // Products
      'products.title': 'Nos Produits',
      'products.subtitle': 'Large gamme de pièces automobiles',
      'products.search': 'Rechercher un produit...',
      'products.filter': 'Filtrer par',
      'products.category': 'Catégorie',
      'products.brand': 'Marque',
      'products.price': 'Prix',
      'products.stock': 'En stock',
      'products.outofstock': 'Rupture',
      'products.details': 'Voir détails',
      'products.addtocart': 'Ajouter au panier',
      
      // Brands
      'brands.title': 'Marques Distribuées',
      'brands.subtitle': 'Nous travaillons avec les meilleures marques',
      
      // Workshops
      'workshops.title': 'Nos Ateliers Partenaires',
      'workshops.subtitle': 'Réseau d\'ateliers de confiance',
      
      // About
      'about.title': 'À Propos de Nous',
      'about.subtitle': 'Leader de la distribution de pièces automobiles en Algérie',
      'about.mission': 'Notre Mission',
      'about.mission.text': 'Fournir des pièces automobiles de qualité avec un service irréprochable',
      'about.vision': 'Notre Vision',
      'about.vision.text': 'Devenir la référence incontournable du secteur automobile',
      'about.values': 'Nos Valeurs',
      'about.quality': 'Qualité',
      'about.reliability': 'Fiabilité',
      'about.service': 'Service Client',
      
      // Contact
      'contact.title': 'Contactez-Nous',
      'contact.subtitle': 'Nous sommes là pour vous aider',
      'contact.name': 'Nom',
      'contact.email': 'Email',
      'contact.phone': 'Téléphone',
      'contact.message': 'Message',
      'contact.send': 'Envoyer',
      'contact.address': 'Adresse',
      'contact.hours': 'Horaires',
      
      // Footer
      'footer.about': 'À Propos',
      'footer.services': 'Services',
      'footer.contact': 'Contact',
      'footer.legal': 'Mentions Légales',
      'footer.privacy': 'Politique de Confidentialité',
      'footer.rights': 'Tous droits réservés',
      
      // Common
      'common.loading': 'Chargement...',
      'common.error': 'Erreur',
      'common.success': 'Succès',
      'common.cancel': 'Annuler',
      'common.save': 'Enregistrer',
      'common.delete': 'Supprimer',
      'common.edit': 'Modifier',
      'common.view': 'Voir',
      'common.add': 'Ajouter',
      'common.search': 'Rechercher',
      'common.filter': 'Filtrer',
      'common.close': 'Fermer',
      'common.submit': 'Soumettre',
    },
  },
  ar: {
    translation: {
      // Navigation
      'nav.home': 'الرئيسية',
      'nav.about': 'من نحن',
      'nav.services': 'خدماتنا',
      'nav.products': 'المنتجات',
      'nav.workshops': 'الورشات',
      'nav.brands': 'العلامات التجارية',
      'nav.contact': 'اتصل بنا',
      'nav.login': 'تسجيل الدخول',
      'nav.dashboard': 'لوحة التحكم',
      
      // Homepage Hero
      'hero.title': 'قطع غيار سيارات عالية الجودة',
      'hero.subtitle': 'شريكك الموثوق لجميع قطع غيار السيارات',
      'hero.cta': 'اكتشف منتجاتنا',
      'hero.cta2': 'اتصل بنا',
      
      // Services
      'services.title': 'خدماتنا',
      'services.subtitle': 'حلول شاملة لجميع احتياجاتك',
      'services.import': 'استيراد القطع',
      'services.import.desc': 'استيراد مباشر من أفضل الموردين العالميين',
      'services.distribution': 'التوزيع',
      'services.distribution.desc': 'شبكة توزيع تغطي كامل التراب الوطني',
      'services.workshop': 'دعم الورشات',
      'services.workshop.desc': 'مرافقة تقنية للمحترفين',
      'services.b2b': 'منصة B2B',
      'services.b2b.desc': 'طلب عبر الإنترنت على مدار الساعة بأسعار مخصصة',
      
      // Products
      'products.title': 'منتجاتنا',
      'products.subtitle': 'مجموعة واسعة من قطع غيار السيارات',
      'products.search': 'بحث عن منتج...',
      'products.filter': 'تصفية حسب',
      'products.category': 'الفئة',
      'products.brand': 'العلامة التجارية',
      'products.price': 'السعر',
      'products.stock': 'متوفر',
      'products.outofstock': 'نفذ من المخزون',
      'products.details': 'عرض التفاصيل',
      'products.addtocart': 'أضف إلى السلة',
      
      // Brands
      'brands.title': 'العلامات التجارية الموزعة',
      'brands.subtitle': 'نعمل مع أفضل العلامات التجارية',
      
      // Workshops
      'workshops.title': 'ورشاتنا الشريكة',
      'workshops.subtitle': 'شبكة من الورشات الموثوقة',
      
      // About
      'about.title': 'من نحن',
      'about.subtitle': 'رائدون في توزيع قطع غيار السيارات في الجزائر',
      'about.mission': 'مهمتنا',
      'about.mission.text': 'توفير قطع غيار سيارات عالية الجودة مع خدمة لا تشوبها شائبة',
      'about.vision': 'رؤيتنا',
      'about.vision.text': 'أن نصبح المرجع الرائد في قطاع السيارات',
      'about.values': 'قيمنا',
      'about.quality': 'الجودة',
      'about.reliability': 'الموثوقية',
      'about.service': 'خدمة العملاء',
      
      // Contact
      'contact.title': 'اتصل بنا',
      'contact.subtitle': 'نحن هنا لمساعدتك',
      'contact.name': 'الاسم',
      'contact.email': 'البريد الإلكتروني',
      'contact.phone': 'الهاتف',
      'contact.message': 'الرسالة',
      'contact.send': 'إرسال',
      'contact.address': 'العنوان',
      'contact.hours': 'ساعات العمل',
      
      // Footer
      'footer.about': 'من نحن',
      'footer.services': 'الخدمات',
      'footer.contact': 'اتصل بنا',
      'footer.legal': 'الشروط القانونية',
      'footer.privacy': 'سياسة الخصوصية',
      'footer.rights': 'جميع الحقوق محفوظة',
      
      // Common
      'common.loading': 'جاري التحميل...',
      'common.error': 'خطأ',
      'common.success': 'نجح',
      'common.cancel': 'إلغاء',
      'common.save': 'حفظ',
      'common.delete': 'حذف',
      'common.edit': 'تعديل',
      'common.view': 'عرض',
      'common.add': 'إضافة',
      'common.search': 'بحث',
      'common.filter': 'تصفية',
      'common.close': 'إغلاق',
      'common.submit': 'إرسال',
    },
  },
  en: {
    translation: {
      // Navigation
      'nav.home': 'Home',
      'nav.about': 'About',
      'nav.services': 'Services',
      'nav.products': 'Products',
      'nav.workshops': 'Workshops',
      'nav.brands': 'Brands',
      'nav.contact': 'Contact',
      'nav.login': 'Login',
      'nav.dashboard': 'Dashboard',
      
      // Homepage Hero
      'hero.title': 'Quality Automotive Parts',
      'hero.subtitle': 'Your trusted partner for all your auto parts',
      'hero.cta': 'Discover our products',
      'hero.cta2': 'Contact us',
      
      // Services
      'services.title': 'Our Services',
      'services.subtitle': 'Complete solutions for all your needs',
      'services.import': 'Parts Import',
      'services.import.desc': 'Direct import from the best global suppliers',
      'services.distribution': 'Distribution',
      'services.distribution.desc': 'Distribution network covering the entire territory',
      'services.workshop': 'Workshop Support',
      'services.workshop.desc': 'Technical support for professionals',
      'services.b2b': 'B2B Platform',
      'services.b2b.desc': '24/7 online ordering with personalized pricing',
      
      // Products
      'products.title': 'Our Products',
      'products.subtitle': 'Wide range of automotive parts',
      'products.search': 'Search for a product...',
      'products.filter': 'Filter by',
      'products.category': 'Category',
      'products.brand': 'Brand',
      'products.price': 'Price',
      'products.stock': 'In stock',
      'products.outofstock': 'Out of stock',
      'products.details': 'View details',
      'products.addtocart': 'Add to cart',
      
      // Brands
      'brands.title': 'Distributed Brands',
      'brands.subtitle': 'We work with the best brands',
      
      // Workshops
      'workshops.title': 'Our Partner Workshops',
      'workshops.subtitle': 'Network of trusted workshops',
      
      // About
      'about.title': 'About Us',
      'about.subtitle': 'Leading automotive parts distributor in Algeria',
      'about.mission': 'Our Mission',
      'about.mission.text': 'Provide quality automotive parts with impeccable service',
      'about.vision': 'Our Vision',
      'about.vision.text': 'Become the leading reference in the automotive sector',
      'about.values': 'Our Values',
      'about.quality': 'Quality',
      'about.reliability': 'Reliability',
      'about.service': 'Customer Service',
      
      // Contact
      'contact.title': 'Contact Us',
      'contact.subtitle': 'We are here to help',
      'contact.name': 'Name',
      'contact.email': 'Email',
      'contact.phone': 'Phone',
      'contact.message': 'Message',
      'contact.send': 'Send',
      'contact.address': 'Address',
      'contact.hours': 'Hours',
      
      // Footer
      'footer.about': 'About',
      'footer.services': 'Services',
      'footer.contact': 'Contact',
      'footer.legal': 'Legal Notice',
      'footer.privacy': 'Privacy Policy',
      'footer.rights': 'All rights reserved',
      
      // Common
      'common.loading': 'Loading...',
      'common.error': 'Error',
      'common.success': 'Success',
      'common.cancel': 'Cancel',
      'common.save': 'Save',
      'common.delete': 'Delete',
      'common.edit': 'Edit',
      'common.view': 'View',
      'common.add': 'Add',
      'common.search': 'Search',
      'common.filter': 'Filter',
      'common.close': 'Close',
      'common.submit': 'Submit',
    },
  },
};
