import React from 'react';

const PartsHubLogo = ({ className = "w-10 h-10" }) => {
  return (
    <svg 
      className={className} 
      viewBox="0 0 100 100" 
      fill="none" 
      xmlns="http://www.w3.org/2000/svg"
    >
      {/* Background Circle */}
      <circle cx="50" cy="50" r="48" fill="#4F46E5" />
      
      {/* Gear/Cog representing auto parts */}
      <path
        d="M50 25 L55 35 L65 33 L63 43 L73 48 L63 53 L65 63 L55 61 L50 71 L45 61 L35 63 L37 53 L27 48 L37 43 L35 33 L45 35 L50 25Z"
        fill="#FFFFFF"
        stroke="#E0E7FF"
        strokeWidth="1.5"
      />
      
      {/* Center hub circle */}
      <circle cx="50" cy="48" r="8" fill="#4F46E5" stroke="#FFFFFF" strokeWidth="2" />
      
      {/* Letter "P" stylized */}
      <path
        d="M46 42 L46 54 M46 42 L50 42 C52 42 54 44 54 46 C54 48 52 48 50 48 L46 48"
        stroke="#FFFFFF"
        strokeWidth="2"
        strokeLinecap="round"
        strokeLinejoin="round"
      />
    </svg>
  );
};

export default PartsHubLogo;
