# 🚀 ERP Auto Algérie - SaaS Intégré

## 📋 Vue d'ensemble

Application ERP complète pour importateurs/distributeurs de pièces auto avec ateliers en Algérie.

---

## ✨ Fonctionnalités Implémentées

### 🌐 **1. Site Vitrine Public**
- ✅ Page d'accueil moderne et responsive
- ✅ Présentation des services (Gestion Stock, Portail B2B, Ateliers, CRM)
- ✅ Section marques distribuées
- ✅ Section contact avec informations
- ✅ Design moderne avec Tailwind CSS
- ✅ Navigation fluide vers connexion

### 🔐 **2. Système d'Authentification**
- ✅ Login sécurisé avec JWT
- ✅ Multi-rôles (SuperAdmin, Admin, Manager, Client)
- ✅ Gestion de session
- ✅ Redirection automatique selon le rôle
- ✅ Interface de connexion intuitive

### 🛠️ **3. Portail de Gestion (Admin/Manager)**

#### Dashboard
- ✅ Statistiques en temps réel:
  - Total produits
  - Alertes stock bas
  - Total clients
  - Commandes en attente
  - Chiffre d'affaires
- ✅ Liste des commandes récentes
- ✅ Graphiques et KPIs

#### Gestion des Produits
- ✅ Liste complète des produits
- ✅ Recherche et filtrage
- ✅ Affichage des stocks avec alertes
- ✅ Tarification multi-niveaux (Public, Garage, Semi-Grossiste, Grossiste)
- ✅ Statistiques de stock (Total, Alertes, Valeur)
- ✅ Interface CRUD préparée

#### Navigation Sidebar
- ✅ Menu latéral moderne
- ✅ Dashboard
- ✅ Produits
- ✅ Commandes (structure prête)
- ✅ Clients (structure prête)
- ✅ Catégories (structure prête)
- ✅ Marques (structure prête)
- ✅ Responsive avec version mobile

---

## 🏗️ Architecture Technique

### Backend (FastAPI + MongoDB)
```
/app/backend/
├── server.py          # API principale avec tous les endpoints
├── models.py          # Modèles Pydantic (Users, Products, Orders, etc.)
├── auth.py            # JWT Authentication & Password hashing
├── dependencies.py    # Middleware & Role-based access
├── seed_data.py       # Données de test initiales
└── requirements.txt   # Dépendances Python
```

**APIs Disponibles:**
- ✅ `/api/auth/login` - Connexion
- ✅ `/api/auth/register` - Inscription
- ✅ `/api/auth/me` - Utilisateur courant
- ✅ `/api/products` - CRUD Produits
- ✅ `/api/orders` - CRUD Commandes
- ✅ `/api/clients` - CRUD Clients
- ✅ `/api/brands` - CRUD Marques
- ✅ `/api/categories` - CRUD Catégories
- ✅ `/api/dashboard/stats` - Statistiques Dashboard
- ✅ `/api/users` - Gestion utilisateurs (Admin)

### Frontend (React + Tailwind CSS)
```
/app/frontend/src/
├── App.js                    # Routes principales
├── i18n.js                   # Internationalisation (FR/AR/EN)
├── contexts/
│   └── AuthContext.js        # Gestion authentification
├── services/
│   ├── api.js                # Client Axios configuré
│   └── authService.js        # Services d'authentification
├── components/
│   └── ui/                   # Composants Shadcn/ui
│       ├── button.jsx
│       ├── card.jsx
│       ├── input.jsx
│       ├── label.jsx
│       ├── table.jsx
│       └── pagination.jsx
├── layouts/
│   └── AdminLayout.jsx       # Layout admin avec sidebar
├── pages/
│   ├── public/
│   │   └── HomePage.jsx      # Site vitrine
│   ├── auth/
│   │   └── Login.jsx         # Page de connexion
│   └── admin/
│       ├── Dashboard.jsx     # Dashboard admin
│       └── ProductsPage.jsx  # Gestion produits
└── index.css                 # Styles Tailwind + Variables CSS
```

---

## 📊 Modèles de Données

### Users
- id, email, password_hash, full_name, phone
- role (superadmin/admin/manager/client)
- is_active, language

### Products
- reference, name, description
- category_id, brand_id
- stock_qty, min_stock
- prices {public, garage, semi_wholesale, wholesale}
- images[], specifications{}, oem_references[]

### Orders
- order_number, client_id, client_name
- status (pending/confirmed/preparing/ready/in_delivery/delivered)
- items[], subtotal, tax_amount (19% TVA), total

### Clients (B2B)
- user_id, company_name
- category (public/garage/semi_wholesale/wholesale/vip)
- credit_limit, payment_terms
- address, city, tax_id, commercial_register

---

## 🔑 Comptes de Test

### Admin
- **Email:** `admin@erpauto.dz`
- **Mot de passe:** `admin123`
- **Rôle:** SuperAdmin

### Client B2B
- **Email:** `client@garage.dz`
- **Mot de passe:** `client123`
- **Rôle:** Client
- **Entreprise:** Garage Mohamed SARL

---

## 🌍 Internationalisation

- ✅ Support multilingue (FR/AR/EN)
- ✅ Traductions de base implémentées
- ✅ Système i18next configuré
- ✅ Prêt pour extension

---

## 🎨 Design & UI/UX

- ✅ Design moderne et professionnel
- ✅ Palette de couleurs indigo/blue
- ✅ Composants Shadcn/ui
- ✅ Responsive mobile-first
- ✅ Animations et transitions fluides
- ✅ Custom scrollbars
- ✅ Icons Lucide React

---

## 🚀 Prochaines Étapes Recommandées

### Phase 2 - Extensions
1. **Portail Client B2B:**
   - Dashboard client personnalisé
   - Catalogue avec recherche avancée (VIN, référence OEM)
   - Panier et commande en ligne
   - Suivi commandes temps réel
   - Historique achats et factures

2. **Gestion Complète Admin:**
   - Pages Commandes avec workflow
   - Gestion Clients avec catégorisation
   - Gestion Catégories et Marques
   - Rapports et exports Excel/PDF

3. **Module Ateliers:**
   - Ordres de réparation (OR)
   - Planning mécanique
   - Facturation atelier
   - Photos véhicules

4. **Fonctionnalités Avancées:**
   - Notifications temps réel (Socket.io)
   - Recherche avancée produits
   - Imports/Exports Excel
   - Gestion documents (GED)
   - Programme fidélité
   - Multi-sites

---

## 📦 Données Seedées

### Marques (4)
- Bosch (Allemagne)
- Mann Filter (Allemagne)
- NGK (Japon)
- Valeo (France)

### Catégories (5)
- Filtres
- Freinage
- Allumage
- Éclairage
- Moteur

### Produits (5)
1. Filtre à huile Bosch - 800 DZD
2. Plaquettes de frein - 4500 DZD
3. Bougie d'allumage NGK - 450 DZD (Stock bas!)
4. Ampoule H7 Valeo - 350 DZD
5. Filtre à air Mann - 1200 DZD

---

## 🔧 Commandes Utiles

### Backend
```bash
# Redémarrer le backend
sudo supervisorctl restart backend

# Voir les logs backend
tail -f /var/log/supervisor/backend.err.log

# Re-seed la database
cd /app/backend && python seed_data.py
```

### Frontend
```bash
# Redémarrer le frontend
sudo supervisorctl restart frontend

# Voir les logs frontend
tail -f /var/log/supervisor/frontend.out.log

# Installer une dépendance
cd /app/frontend && yarn add <package>
```

---

## 📝 Notes Importantes

1. **MongoDB:** Base de données locale sur port 27017
2. **Backend:** FastAPI sur port 8001 avec hot-reload
3. **Frontend:** React sur port 3000 avec hot-reload
4. **CORS:** Configuré pour accepter toutes les origines en dev
5. **JWT:** Tokens valides 24h
6. **TVA:** 19% appliquée automatiquement sur les commandes

---

## 🎯 Points Forts du Projet

✨ **Architecture Moderne:** FastAPI + React + MongoDB
✨ **Authentification Sécurisée:** JWT avec rôles
✨ **UI Professionnelle:** Shadcn/ui + Tailwind CSS
✨ **Responsive Design:** Mobile-first
✨ **Code Modulaire:** Séparation claire des responsabilités
✨ **Prêt pour Production:** Structure scalable
✨ **Multilingue:** Support FR/AR/EN
✨ **Conformité Algérienne:** TVA 19%, formats prix DZD

---

## 📞 Support

Pour toute question ou assistance, contactez l'équipe de développement.

**Version:** 1.0.0 (MVP Phase 1)
**Date:** Janvier 2025
**Statut:** ✅ Opérationnel

---

**🎉 L'application est prête à être utilisée et testée!**
